//package globalExamples;

import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.LiteralQualification;
import oracle.olapi.data.source.Qualification;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.StringSource;

import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMeasureModel;
import oracle.olapi.metadata.mdm.MdmModel;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmStandardDimension;
import oracle.olapi.metadata.mdm.MdmStandardMember;

/**
 * This program creates a custom member of the Product dimension.
 * The program contains the code that appears in Example 2-1, Creating a
 * Custom Member of a Dimension, in Chapter 2, Understanding OLAP API Metadata,
 * in the Oracle OLAP Developer's Guide to the OLAP API.
 *
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 *
 * @author Oracle Corporation
 */
public class CreateCustomDimensionMember
{

  public void run(String[] args)
  {
    // Create a PrintWriter and objects for connecting to the database and
    // getting the metadata.
    Context10g context = new Context10g(args, false);

    // Get the DataProvider.
    DataProvider dp = context.getDataProvider();

    // Get the dimensions.
    MdmStandardDimension mdmProdStdDim =
        (MdmStandardDimension) context.getMdmPrimaryDimensionByName("PRODUCT");
    MdmPrimaryDimension mdmTimeDim = context.getMdmPrimaryDimensionByName("TIME");

    // Get the Source for the Product dimension.
    Source prodStdDim = mdmProdStdDim.getSource();

    // Get the default hierarchies of the dimensions and the Source objects for them.
    MdmLevelHierarchy mdmCalendar = (MdmLevelHierarchy)
                                     mdmTimeDim.getDefaultHierarchy();
    MdmLevelHierarchy mdmProdRollup = (MdmLevelHierarchy)
                                      mdmProdStdDim.getDefaultHierarchy();
    StringSource calendar = (StringSource) mdmCalendar.getSource();
    StringSource prodRollup = (StringSource) mdmProdRollup.getSource();

    // Get the Unit Cost and Unit Price measures and the Source objects for them.
    MdmMeasure mdmUnitCost = context.getMdmMeasureByName("UNIT_COST");
    MdmMeasure mdmUnitPrice = context.getMdmMeasureByName("UNIT_PRICE");

    NumberSource unitCost = (NumberSource) mdmUnitCost.getSource();
    NumberSource unitPrice = (NumberSource) mdmUnitPrice.getSource();

    // Get the placeholder Source for the Number data type.
    Source ph = dp.getFundamentalMetadataProvider()
                  .getNumberPlaceholder()
                  .getSource();

    // Create a Source that specifies the value to assign as the
    // value of a measure for the custom dimension member.
    Source calc = ((NumberSource)
                  (ph.join(prodRollup, "PRODUCT_ROLLUP::ITEM::14")))
                  .plus(
                  (NumberSource)
                  (ph.join(prodRollup, "PRODUCT_ROLLUP::ITEM::15")));

    // Get the level to which the dimension members belong.
    MdmLevel mdmItemLevel = context.getLevelByName(mdmProdRollup, "ITEM");

    // Create the custom dimension member.
    MdmStandardMember mdmItem60 = mdmProdStdDim.createCustomMember(
                                                  "60",  // member local value
                                                  mdmItemLevel, // member level
                                                  "4",   // parent local value
                                                  calc, // calculation Source
                                                  10);   // precedence value

    // Select a set of Product member values.
    StringSource prodSel = prodRollup.selectValues(
                                    new String[]{"PRODUCT_ROLLUP::ITEM::14",
                                                 "PRODUCT_ROLLUP::ITEM::15",
                                                 "PRODUCT_ROLLUP::ITEM::60"});

    // Produce a query that specifies the unit price and the unit cost for the
    // selected products and the specified month. The month does not appear
    // in the result.
    Source result = unitPrice.join(unitCost)
                             .join(prodSel)
                             .join(calendar, "CALENDAR::MONTH::47");

    // Prepare and commit the current Transaction.
    context.commit();

    // Create a Cursor for the result Source and display the values of the Cursor.
    context.displayResult(result);


  }

  public static void main(String[] args)
  {
    new CreateCustomDimensionMember().run(args);
  }
}


